#ifndef _NPLOOKUP_H
#define _NPLOOKUP_H

#include "UnityNP.h"

namespace UnityPlugin
{
	class NpLookup
	{
	private:
		enum State
		{
			STATE_START_USER_NPID,
			STATE_PROCESS_USER_NPID,

			STATE_START_USER_INFO,
			STATE_PROCESS_USER_INFO,

			STATE_ALL_FINISHED,
			STATE_MAX
		};

		int m_TitleCtxId;
		int m_RequestID;
		int m_Result;
		int m_ResultUserNpID;
		int m_ResultUserProfile;

		State m_State;
		State m_StateAfterComplete;

		SceNpOnlineId m_UserOnlineId;
		SceNpId m_UserNpId;
		SceNpUserInfo m_UserInfo;
		SceNpAboutMe m_AboutMe;
		SceNpMyLanguages m_Languages;
		SceNpCountryCode m_CountryCode;
		int m_LastErrorCode;
		std::string m_LastErrorMessage;

	public:
		enum NpLookupResult
		{
			NPLOOKUP_OK,
			NPLOOKUP_IDLE,
			NPLOOKUP_BUSY,
			NPLOOKUP_FAILED,
			NPLOOKUP_GOT_NPID,
			NPLOOKUP_GOT_USERINFO,
		};

	public:
		NpLookup();
		~NpLookup();

		bool IsBusy() const;
		NpLookupResult LookupUserNpID(const SceNpId& myNpID, const SceNpOnlineId& userOnlineID);
		NpLookupResult LookupUserInfo(const SceNpId& myNpID, const SceNpOnlineId& userOnlineID);
		NpLookupResult LookupUserInfo(const SceNpId& myNpID, const SceNpId& userNpID);
		NpLookupResult Update();

		const SceNpOnlineId& GetUserOnlineID() const { return m_UserOnlineId; }
		const SceNpId& GetUserNpID() const { return m_UserNpId; }
		const SceNpUserInfo& GetUserInfo() const { return m_UserInfo; }
		const SceNpAboutMe& GetAboutMe() const { return  m_AboutMe; }
		const SceNpMyLanguages& GetLanguages() const { return m_Languages; }
		const SceNpCountryCode& GetCountryCode() const { return m_CountryCode; }

		int GetLastErrorCode() const { return m_LastErrorCode; }
		const char* GetLastErrorMessage() const { return m_LastErrorMessage.c_str(); }

	private:
		NpLookupResult DoLookup(bool finishedAsync);
		NpLookupResult AsyncOpError(int errorCode, const char* function, int line);
		NpLookupResult Error(int errorCode, const char* function, int line);
		NpLookupResult Initialize(const SceNpId& myNpID);
		void Shutdown();
	};
}

#endif
